/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import slimeknights.mantle.recipe.helper.ItemOutput;

public class ItemNameOutput
extends ItemOutput {
    private final class_2960 name;
    private final int count;
    @Nullable
    private final class_2487 nbt;

    public static ItemNameOutput fromName(class_2960 name, int count) {
        return ItemNameOutput.fromName(name, count, null);
    }

    public static ItemNameOutput fromName(class_2960 name) {
        return ItemNameOutput.fromName(name, 1);
    }

    @Override
    public class_1799 get() {
        throw new UnsupportedOperationException("Cannot get the item stack from a item name output");
    }

    @Override
    public JsonElement serialize() {
        String itemName = this.name.toString();
        if (this.nbt == null && this.count <= 1) {
            return new JsonPrimitive(itemName);
        }
        JsonObject jsonResult = new JsonObject();
        jsonResult.addProperty("item", itemName);
        if (this.count > 1) {
            jsonResult.addProperty("count", (Number)this.count);
        }
        if (this.nbt != null) {
            jsonResult.addProperty("nbt", this.nbt.toString());
        }
        return jsonResult;
    }

    private ItemNameOutput(class_2960 name, int count, @Nullable class_2487 nbt) {
        this.name = name;
        this.count = count;
        this.nbt = nbt;
    }

    public static ItemNameOutput fromName(class_2960 name, int count, @Nullable class_2487 nbt) {
        return new ItemNameOutput(name, count, nbt);
    }
}

